
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
eggs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="eggs")
tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
chicken_breasts = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_breasts")
strawberries = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")


# Set objective function
m.setObjective(4.88 * eggs + 2.72 * tomatoes + 4.85 * chicken_breasts + 8.32 * strawberries, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 17.27 * strawberries >= 68)
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 25.41 * chicken_breasts >= 68)
m.addConstr(15.41 * tomatoes + 25.41 * chicken_breasts + 17.27 * strawberries >= 68)
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 17.27 * strawberries >= 80)
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 25.41 * chicken_breasts >= 80)
m.addConstr(15.41 * tomatoes + 25.41 * chicken_breasts + 17.27 * strawberries >= 80)
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 17.27 * strawberries >= 51)
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 25.41 * chicken_breasts >= 51)
m.addConstr(15.41 * tomatoes + 25.41 * chicken_breasts + 17.27 * strawberries >= 51)
m.addConstr(5.49 * chicken_breasts + 1.55 * strawberries >= 71)
m.addConstr(2.33 * tomatoes + 4.53 * chicken_breasts >= 18)
m.addConstr(25.18 * eggs + 4.53 * chicken_breasts >= 41)
m.addConstr(25.18 * eggs + 2.33 * tomatoes >= 39)
m.addConstr(2.33 * tomatoes + 4.53 * chicken_breasts + 2.26 * strawberries >= 42)
m.addConstr(23.23 * eggs + 3.71 * strawberries >= 32)
m.addConstr(23.23 * eggs + 15.92 * tomatoes + 26.77 * chicken_breasts >= 42)
m.addConstr(15.92 * tomatoes + 26.77 * chicken_breasts + 3.71 * strawberries >= 42)
m.addConstr(23.23 * eggs + 15.92 * tomatoes + 26.77 * chicken_breasts >= 46)
m.addConstr(15.92 * tomatoes + 26.77 * chicken_breasts + 3.71 * strawberries >= 46)
m.addConstr(8.08 * chicken_breasts + 14.37 * strawberries >= 25)
m.addConstr(7.4 * eggs + 2.61 * tomatoes >= 19)
m.addConstr(7.4 * eggs + 8.08 * chicken_breasts >= 36)
m.addConstr(2.61 * tomatoes + 14.37 * strawberries >= 28)
m.addConstr(7.4 * eggs + 14.37 * strawberries >= 15)
m.addConstr(7.4 * eggs + 2.61 * tomatoes + 8.08 * chicken_breasts >= 31)
m.addConstr(15.41 * tomatoes + 25.41 * chicken_breasts <= 321)
m.addConstr(15.3 * eggs + 17.27 * strawberries <= 255)
m.addConstr(15.3 * eggs + 25.41 * chicken_breasts <= 325)
m.addConstr(15.3 * eggs + 15.41 * tomatoes <= 148)
m.addConstr(25.41 * chicken_breasts + 17.27 * strawberries <= 246)
m.addConstr(15.3 * eggs + 15.41 * tomatoes + 25.41 * chicken_breasts + 17.27 * strawberries <= 246)
m.addConstr(13.57 * tomatoes + 1.55 * strawberries <= 301)
m.addConstr(15.91 * eggs + 5.49 * chicken_breasts <= 286)
m.addConstr(15.91 * eggs + 13.57 * tomatoes + 5.49 * chicken_breasts + 1.55 * strawberries <= 286)
m.addConstr(25.18 * eggs + 4.53 * chicken_breasts <= 182)
m.addConstr(2.33 * tomatoes + 2.26 * strawberries <= 195)
m.addConstr(25.18 * eggs + 2.33 * tomatoes + 4.53 * chicken_breasts + 2.26 * strawberries <= 195)
m.addConstr(15.92 * tomatoes + 3.71 * strawberries <= 172)
m.addConstr(23.23 * eggs + 3.71 * strawberries <= 149)
m.addConstr(23.23 * eggs + 26.77 * chicken_breasts <= 163)
m.addConstr(26.77 * chicken_breasts + 3.71 * strawberries <= 85)
m.addConstr(23.23 * eggs + 15.92 * tomatoes <= 164)
m.addConstr(23.23 * eggs + 26.77 * chicken_breasts + 3.71 * strawberries <= 148)
m.addConstr(23.23 * eggs + 15.92 * tomatoes + 26.77 * chicken_breasts <= 60)
m.addConstr(23.23 * eggs + 15.92 * tomatoes + 26.77 * chicken_breasts + 3.71 * strawberries <= 60)
m.addConstr(7.4 * eggs + 2.61 * tomatoes <= 179)
m.addConstr(2.61 * tomatoes + 8.08 * chicken_breasts <= 105)
m.addConstr(2.61 * tomatoes + 14.37 * strawberries <= 109)
m.addConstr(8.08 * chicken_breasts + 14.37 * strawberries <= 111)
m.addConstr(7.4 * eggs + 2.61 * tomatoes + 14.37 * strawberries <= 87)
m.addConstr(7.4 * eggs + 2.61 * tomatoes + 8.08 * chicken_breasts + 14.37 * strawberries <= 87)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

