
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["rubber gloves", "packs of paper plates", "toilet paper rolls", "diapers"])


    # Set objective function
    m.setObjective(6*x[0] + 4*x[1] + 7*x[2] + 4*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x[0] + 18*x[2] + 23*x[3] >= 61)
    m.addConstr(12*x[0] + 7*x[1] + 23*x[3] >= 61)
    m.addConstr(7*x[1] + 18*x[2] + 23*x[3] >= 61)
    m.addConstr(12*x[0] + 18*x[2] + 23*x[3] >= 38)
    m.addConstr(12*x[0] + 7*x[1] + 23*x[3] >= 38)
    m.addConstr(7*x[1] + 18*x[2] + 23*x[3] >= 38)
    m.addConstr(12*x[0] + 18*x[2] + 23*x[3] >= 43)
    m.addConstr(12*x[0] + 7*x[1] + 23*x[3] >= 43)
    m.addConstr(7*x[1] + 18*x[2] + 23*x[3] >= 43)
    m.addConstr(12*x[0] + 7*x[1] <= 67)
    m.addConstr(7*x[1] + 23*x[3] <= 170)
    m.addConstr(18*x[2] + 23*x[3] <= 91)
    m.addConstr(12*x[0] + 23*x[3] <= 225)
    m.addConstr(12*x[0] + 7*x[1] + 18*x[2] + 23*x[3] <= 225)
    m.addConstr(23*x[0] + 12*x[2] <= 111)
    m.addConstr(23*x[0] + 16*x[1] <= 164)
    m.addConstr(16*x[1] + 12*x[2] <= 149)
    m.addConstr(23*x[0] + 12*x[2] + 24*x[3] <= 161)
    m.addConstr(23*x[0] + 16*x[1] + 12*x[2] + 24*x[3] <= 161)
    m.addConstr(12*x[0] + 7*x[1] + 18*x[2] + 23*x[3] <= 248)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
