
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="rubber gloves", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="packs of paper plates", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="toilet paper rolls", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="diapers", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6*x0 + 4*x1 + 7*x2 + 4*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(12*x0 + 18*x2 + 23*x3 >= 61)
m.addConstr(12*x0 + 7*x1 + 23*x3 >= 61)
m.addConstr(7*x1 + 18*x2 + 23*x3 >= 61)
m.addConstr(12*x0 + 18*x2 + 23*x3 >= 38)
m.addConstr(12*x0 + 7*x1 + 23*x3 >= 38)
m.addConstr(7*x1 + 18*x2 + 23*x3 >= 38)
m.addConstr(12*x0 + 18*x2 + 23*x3 >= 43)
m.addConstr(12*x0 + 7*x1 + 23*x3 >= 43)
m.addConstr(7*x1 + 18*x2 + 23*x3 >= 43)
m.addConstr(12*x0 + 7*x1 <= 67)
m.addConstr(7*x1 + 23*x3 <= 170)
m.addConstr(18*x2 + 23*x3 <= 91)
m.addConstr(12*x0 + 23*x3 <= 225)
m.addConstr(12*x0 + 7*x1 + 18*x2 + 23*x3 <= 225)
m.addConstr(23*x0 + 12*x2 <= 111)
m.addConstr(23*x0 + 16*x1 <= 164)
m.addConstr(16*x1 + 12*x2 <= 149)
m.addConstr(23*x0 + 12*x2 + 24*x3 <= 161)
m.addConstr(23*x0 + 16*x1 + 12*x2 + 24*x3 <= 161)

# Set bounds for resources
m.addConstr(x0 <= 248/12)
m.addConstr(x1 <= 248/7)
m.addConstr(x2 <= 248/18)
m.addConstr(x3 <= 248/23)

m.addConstr(23*x0 + 12*x2 <= 164)
m.addConstr(23*x0 + 16*x1 <= 164)
m.addConstr(16*x1 + 12*x2 <= 149)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("rubber gloves: ", x0.varValue)
    print("packs of paper plates: ", x1.varValue)
    print("toilet paper rolls: ", x2.varValue)
    print("diapers: ", x3.varValue)
else:
    print("The model is infeasible")
