
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
    x1 = m.addVar(vtype=GRB.INTEGER, name="candles")


    # Set objective function
    m.setObjective(1*x0 + 5*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 8*x1 >= 35, "value_constraint1")
    m.addConstr(1*x0 + 2*x1 >= 7, "portability_constraint1")
    m.addConstr(-4*x0 + 9*x1 >= 0, "constraint3")
    m.addConstr(5*x0 + 8*x1 <= 54, "value_constraint2")
    m.addConstr(1*x0 + 2*x1 <= 39, "portability_constraint2")


    # Resource constraints (converted to individual variable bounds)
    m.addConstr(x0 <= 70/5, "resource_r0_x0")
    m.addConstr(x1 <= 70/8, "resource_r0_x1")
    m.addConstr(x0 <= 41/1, "resource_r1_x0")
    m.addConstr(x1 <= 41/2, "resource_r1_x1")

    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("Packs of paper plates:", x0.x)
        print("Candles:", x1.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
