
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
x1 = m.addVar(vtype=GRB.INTEGER, name="candles")

# Set the objective function
m.setObjective(1*x0 + 5*x1, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(5*x0 + 8*x1 >= 35, "total_value_min")
m.addConstr(1*x0 + 2*x1 >= 7, "portability_rating_min")
m.addConstr(-4*x0 + 9*x1 >= 0, "custom_constraint")
m.addConstr(5*x0 + 8*x1 <= 54, "total_value_max")
m.addConstr(1*x0 + 2*x1 <= 39, "portability_rating_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of paper plates: {x0.x}")
    print(f"Candles: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
