
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="packs_of_paper_plates", vtype=gp.GRB.INTEGER)  # packs of paper plates
x2 = m.addVar(name="candles", vtype=gp.GRB.INTEGER)  # candles

# Objective function: minimize 1*x1 + 5*x2
m.setObjective(x1 + 5*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 8*x2 >= 35, name="total_value_min")
m.addConstr(x1 + 2*x2 >= 7, name="total_portability_min")
m.addConstr(-4*x1 + 9*x2 >= 0, name="combined_value_constraint")
m.addConstr(5*x1 + 8*x2 <= 54, name="total_value_max")
m.addConstr(x1 + 2*x2 <= 39, name="total_portability_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("packs of paper plates: ", x1.varValue)
    print("candles: ", x2.varValue)
else:
    print("The model is infeasible")
