
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="jean_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


# Set objective function
obj = 2*laura_hours**2 + 2*laura_hours*mary_hours + 7*laura_hours*bill_hours + 3*laura_hours*jean_hours + 8*laura_hours*peggy_hours + 8*mary_hours**2 + 8*mary_hours*bill_hours + 1*mary_hours*jean_hours + 5*mary_hours*peggy_hours + 7*bill_hours**2 + 5*bill_hours*jean_hours + 2*bill_hours*peggy_hours + 5*jean_hours**2 + 8*jean_hours*peggy_hours + 8*peggy_hours**2 + 4*laura_hours + 4*mary_hours + 5*bill_hours + 1*jean_hours + 3*peggy_hours

m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*laura_hours + 5*mary_hours + 8*bill_hours + 17*jean_hours + 9*peggy_hours <= 211, "r0")
m.addConstr(1*laura_hours + 12*mary_hours + 3*bill_hours + 9*jean_hours + 11*peggy_hours <= 402, "r1")
m.addConstr(6*laura_hours + 16*mary_hours + 16*bill_hours + 9*jean_hours + 16*peggy_hours <= 361, "r2")

# ... (Rest of the constraints from the JSON "constraints" field)
# Example:
m.addConstr(5*mary_hours + 17*jean_hours >= 36)
# ... (Add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours:', laura_hours.x)
    print('Mary Hours:', mary_hours.x)
    print('Bill Hours:', bill_hours.x)
    print('Jean Hours:', jean_hours.x)
    print('Peggy Hours:', peggy_hours.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

