
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Hank", "Laura", "John", "Dale", "Peggy"])


    # Set objective function
    m.setObjective(2*x[0] + 5*x[1] + 8*x[2] + 4*x[3] + 8*x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11*x[0] + 2*x[1] + 10*x[4] >= 18)
    m.addConstr(10*x[2] + 5*x[3] >= 11)
    m.addConstr(x[0] + 11*x[1] >= 30)
    m.addConstr(11*x[1] + 5*x[3] >= 26)
    m.addConstr(x[0] + 10*x[2] >= 17)
    m.addConstr(x[0] + 5*x[3] >= 12)
    m.addConstr(x[0] + 11*x[1] + 10*x[2] >= 25)
    m.addConstr(10*x[2] + 5*x[3] + 3*x[4] >= 25)
    m.addConstr(x[0] + 10*x[2] + 5*x[3] >= 25)
    m.addConstr(11*x[1] + 5*x[3] + 3*x[4] >= 25)
    m.addConstr(x[0] + 11*x[1] + 10*x[2] >= 21)
    m.addConstr(10*x[2] + 5*x[3] + 3*x[4] >= 21)
    m.addConstr(x[0] + 10*x[2] + 5*x[3] >= 21)
    m.addConstr(11*x[1] + 5*x[3] + 3*x[4] >= 21)
    m.addConstr(x[0] + 11*x[1] + 10*x[2] >= 22)
    m.addConstr(10*x[2] + 5*x[3] + 3*x[4] >= 22)
    m.addConstr(x[0] + 10*x[2] + 5*x[3] >= 22)
    m.addConstr(11*x[1] + 5*x[3] + 3*x[4] >= 22)

    m.addConstr(3*x[3] + 10*x[4] <= 76)
    m.addConstr(2*x[1] + 3*x[3] <= 87)
    m.addConstr(11*x[0] + 2*x[1] <= 72)
    m.addConstr(x[2] + 3*x[3] <= 92)
    m.addConstr(11*x[0] + 3*x[3] <= 69)
    m.addConstr(11*x[0] + 3*x[3] + 10*x[4] <= 33)
    m.addConstr(11*x[0] + 2*x[1] + 10*x[4] <= 129)
    m.addConstr(11*x[0] + 2*x[1] + x[2] + 3*x[3] + 10*x[4] <= 129)
    m.addConstr(x[0] + 3*x[4] <= 49)
    m.addConstr(11*x[1] + 10*x[2] <= 101)
    m.addConstr(11*x[1] + 3*x[4] <= 159)
    m.addConstr(x[0] + 11*x[1] + 5*x[3] <= 132)
    m.addConstr(x[0] + 5*x[3] + 3*x[4] <= 160)
    m.addConstr(x[0] + 10*x[2] + 5*x[3] <= 109)
    m.addConstr(x[0] + 11*x[1] + 10*x[2] <= 153)
    m.addConstr(11*x[1] + 5*x[3] + 3*x[4] <= 113)
    m.addConstr(x[0] + 10*x[2] + 3*x[4] <= 85)
    m.addConstr(10*x[2] + 5*x[3] + 3*x[4] <= 85)
    m.addConstr(11*x[1] + 10*x[2] + 5*x[3] <= 85)
    m.addConstr(x[0] + 11*x[1] + 10*x[2] + 5*x[3] + 3*x[4] <= 85)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f'Error code {e.errno}: {e}')
except AttributeError:
    print('Encountered an attribute error')
