
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Hank
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Laura
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Dale
    x4 = model.addVar(name="x4", lb=0)  # hours worked by Peggy

    # Set x0 = 1 (from constraint 1)
    model.addConstr(x0 == 1)

    # Add constraints
    model.addConstr(11*x0 + 2*x1 + 10*x4 >= 18)
    model.addConstr(10*x2 + 5*x3 >= 11)
    model.addConstr(x0 + 11*x1 >= 30)
    model.addConstr(11*x1 + 5*x3 >= 26)
    model.addConstr(x0 + 10*x2 >= 17)
    model.addConstr(x0 + 5*x3 >= 12)
    model.addConstr(x0 + 11*x1 + 10*x2 >= 25)
    model.addConstr(10*x2 + 5*x3 + 3*x4 >= 25)
    model.addConstr(x0 + 10*x2 + 5*x3 >= 25)
    model.addConstr(11*x1 + 5*x3 + 3*x4 >= 25)
    model.addConstr(x0 + 11*x1 + 10*x2 >= 21)
    model.addConstr(10*x2 + 5*x3 + 3*x4 >= 21)
    model.addConstr(x0 + 10*x2 + 5*x3 >= 21)
    model.addConstr(11*x1 + 5*x3 + 3*x4 >= 21)
    model.addConstr(x0 + 11*x1 + 10*x2 >= 22)
    model.addConstr(10*x2 + 5*x3 + 3*x4 >= 22)
    model.addConstr(x0 + 10*x2 + 5*x3 >= 22)
    model.addConstr(11*x1 + 5*x3 + 3*x4 >= 22)
    model.addConstr(3*x3 + 10*x4 <= 76)
    model.addConstr(2*x1 + 3*x3 <= 87)
    model.addConstr(11*x0 + 2*x1 <= 72)
    model.addConstr(x2 + 3*x3 <= 92)
    model.addConstr(11*x0 + 3*x3 <= 69)
    model.addConstr(11*x0 + 3*x3 + 10*x4 <= 33)
    model.addConstr(11*x0 + 2*x1 + 10*x4 <= 129)
    model.addConstr(11*x0 + 2*x1 + x2 + 3*x3 + 10*x4 <= 129)
    model.addConstr(x0 + 3*x4 <= 49)
    model.addConstr(11*x1 + 10*x2 <= 101)
    model.addConstr(11*x1 + 3*x4 <= 159)
    model.addConstr(x0 + 11*x1 + 5*x3 <= 132)
    model.addConstr(x0 + 5*x3 + 3*x4 <= 160)
    model.addConstr(x0 + 10*x2 + 5*x3 <= 109)
    model.addConstr(x0 + 11*x1 + 10*x2 <= 153)
    model.addConstr(11*x1 + 5*x3 + 3*x4 <= 113)
    model.addConstr(x0 + 10*x2 + 3*x4 <= 85)
    model.addConstr(10*x2 + 5*x3 + 3*x4 <= 85)
    model.addConstr(11*x1 + 10*x2 + 5*x3 <= 85)
    model.addConstr(x0 + 11*x1 + 10*x2 + 5*x3 + 3*x4 <= 85)

    # Objective function
    model.setObjective(2*x0 + 5*x1 + 8*x2 + 4*x3 + 8*x4, gurobi.GRB.MAXIMIZE)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Hank: ", x0.varValue)
        print("Hours worked by Laura: ", x1.varValue)
        print("Hours worked by John: ", x2.varValue)
        print("Hours worked by Dale: ", x3.varValue)
        print("Hours worked by Peggy: ", x4.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
