
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0")  # hours worked by Paul
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1")  # hours worked by Peggy
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2")  # hours worked by Bobby
    x3 = m.addVar(vtype=GRB.CONTINUOUS, name="x3")  # hours worked by Mary


    # Set objective function
    m.setObjective(7*x0*x1 + 6*x1*x2 + 6*x3**2 + x0 + 7*x3, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15.1*x0**2 + 18.65*x1**2 >= 26)
    m.addConstr(15.1*x0 + 7.75*x2 >= 26)
    m.addConstr(7.75*x2 + 0.8*x3 >= 15)
    m.addConstr(18.65*x1 + 0.8*x3 >= 20)
    m.addConstr(15.1*x0 + 18.65*x1 + 0.8*x3 >= 28)
    m.addConstr(15.1*x0 + 18.65*x1 + 7.75*x2 + 0.8*x3 >= 28)
    m.addConstr(9.85*x0 + 17.94*x1 >= 25)
    m.addConstr(9.85*x0**2 + 17.94*x1**2 + 7.48*x2**2 >= 53)
    m.addConstr(9.85*x0 + 7.48*x2 + 1.13*x3 >= 53)
    m.addConstr(9.85*x0**2 + 17.94*x1**2 + 1.13*x3**2 >= 53)
    m.addConstr(9.85*x0**2 + 17.94*x1**2 + 7.48*x2**2 >= 45)
    m.addConstr(9.85*x0 + 7.48*x2 + 1.13*x3 >= 45)
    m.addConstr(9.85*x0 + 17.94*x1 + 1.13*x3 >= 45)
    m.addConstr(9.85*x0 + 17.94*x1 + 7.48*x2 >= 32)
    m.addConstr(9.85*x0 + 7.48*x2 + 1.13*x3 >= 32)
    m.addConstr(9.85*x0**2 + 17.94*x1**2 + 1.13*x3**2 >= 32)
    m.addConstr(9.85*x0 + 17.94*x1 + 7.48*x2 + 1.13*x3 >= 32)
    m.addConstr(-3*x0 + 7*x2 >= 0)
    m.addConstr(18.65*x1 + 7.75*x2 + 0.8*x3 <= 74)
    m.addConstr(15.1*x0 + 18.65*x1 + 0.8*x3 <= 137)
    m.addConstr(15.1*x0**2 + 7.75*x2**2 + 0.8*x3**2 <= 103)
    m.addConstr(17.94*x1 + 7.48*x2 <= 245)
    m.addConstr(9.85*x0 + 1.13*x3 <= 226)
    m.addConstr(9.85*x0 + 17.94*x1 + 1.13*x3 <= 206)
    m.addConstr(9.85*x0 + 17.94*x1 + 7.48*x2 <= 127)
    m.addConstr(9.85*x0 + 7.48*x2 + 1.13*x3 <= 150)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
