
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(lb=0, name="x0", vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Paul
x1 = m.addVar(lb=0, name="x1", vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Peggy
x2 = m.addVar(lb=0, name="x2", vtype=gurobi.GRB.INTEGER)    # hours worked by Bobby
x3 = m.addVar(lb=0, name="x3", vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Mary

# Objective function
m.setObjective(7*x0*x1 + 6*x1*x2 + 6*x3**2 + x0 + 7*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(15.1 * x0 <= 173)
m.addConstr(9.85 * x0 <= 256)
m.addConstr(18.65 * x1 <= 173)
m.addConstr(17.94 * x1 <= 256)
m.addConstr(7.75 * x2 <= 173)
m.addConstr(7.48 * x2 <= 256)
m.addConstr(0.8 * x3 <= 173)
m.addConstr(1.13 * x3 <= 256)
m.addConstr(15.1**2 * x0**2 + 18.65**2 * x1**2 >= 26)
m.addConstr(15.1 * x0 + 7.75 * x2 >= 26)
m.addConstr(7.75 * x2 + 0.8 * x3 >= 15)
m.addConstr(18.65 * x1 + 0.8 * x3 >= 20)
m.addConstr(15.1 * x0 + 18.65 * x1 + 0.8 * x3 >= 28)
m.addConstr(15.1 * x0 + 18.65 * x1 + 7.75 * x2 + 0.8 * x3 >= 28)
m.addConstr(9.85 * x0 + 17.94 * x1 >= 25)
m.addConstr(9.85**2 * x0**2 + 17.94**2 * x1**2 + 7.48**2 * x2**2 >= 53)
m.addConstr(9.85 * x0 + 7.48 * x2 + 1.13 * x3 >= 53)
m.addConstr(9.85**2 * x0**2 + 17.94**2 * x1**2 + 1.13**2 * x3**2 >= 53)
m.addConstr(9.85**2 * x0**2 + 17.94**2 * x1**2 + 7.48**2 * x2**2 >= 45)
m.addConstr(9.85 * x0 + 7.48 * x2 + 1.13 * x3 >= 45)
m.addConstr(9.85 * x0 + 17.94 * x1 + 1.13 * x3 >= 45)
m.addConstr(9.85 * x0 + 17.94 * x1 + 7.48 * x2 >= 32)
m.addConstr(9.85 * x0 + 7.48 * x2 + 1.13 * x3 >= 32)
m.addConstr(9.85**2 * x0**2 + 17.94**2 * x1**2 + 1.13**2 * x3**2 >= 32)
m.addConstr(9.85 * x0 + 17.94 * x1 + 7.48 * x2 + 1.13 * x3 >= 32)
m.addConstr(-3 * x0 + 7 * x2 >= 0)
m.addConstr(18.65 * x1 + 7.75 * x2 + 0.8 * x3 <= 74)
m.addConstr(15.1 * x0 + 18.65 * x1 + 0.8 * x3 <= 137)
m.addConstr(15.1**2 * x0**2 + 7.75**2 * x2**2 + 0.8**2 * x3**2 <= 103)
m.addConstr(17.94 * x1 + 7.48 * x2 <= 245)
m.addConstr(9.85 * x0 + 1.13 * x3 <= 226)
m.addConstr(9.85 * x0 + 17.94 * x1 + 1.13 * x3 <= 206)
m.addConstr(9.85 * x0 + 17.94 * x1 + 7.48 * x2 <= 127)
m.addConstr(9.85 * x0 + 7.48 * x2 + 1.13 * x3 <= 150)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("No solution found")
