
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Military Optimization")

# Create variables
armored = m.addVar(vtype=GRB.INTEGER, name="armored")
airborne = m.addVar(vtype=GRB.INTEGER, name="airborne")
air_defense = m.addVar(vtype=GRB.INTEGER, name="air_defense")


# Set objective function
m.setObjective(9 * armored + 5 * airborne + 7 * air_defense, GRB.MAXIMIZE)

# Add constraints
m.addConstr(-3 * armored + 6 * air_defense >= 0, "c1")
m.addConstr(11 * armored + 15 * air_defense <= 75, "c2")
m.addConstr(9 * airborne + 15 * air_defense <= 120, "c3")
m.addConstr(11 * armored + 9 * airborne + 15 * air_defense <= 120, "c4")

# Ensure non-negativity for integer variables
m.addConstr(armored >= 0)
m.addConstr(airborne >= 0)
m.addConstr(air_defense >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of armored companies: {armored.x}")
    print(f"Number of airborne infantry companies: {airborne.x}")
    print(f"Number of air defense batteries: {air_defense.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

