
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="armored_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
x3 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")

# Objective function
m.setObjective(9*x1 + 5*x2 + 7*x3, GRB.MAXIMIZE)

# Constraints
m.addConstr(-3*x1 + 6*x3 >= 0, "armored_and_air_defense_constraint")
m.addConstr(11*x1 + 15*x3 <= 75, "total_armored_and_air_defense_rating")
m.addConstr(9*x2 + 15*x3 <= 120, "total_airborne_and_air_defense_rating")
m.addConstr(11*x1 + 9*x2 + 15*x3 <= 135, "total_defensive_capability")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Armored Companies: {x1.x}")
    print(f"Airborne Infantry Companies: {x2.x}")
    print(f"Air Defense Batteries: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
