
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="armored_companies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9 * x1 + 5 * x2 + 7 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(-3 * x1 + 6 * x3 >= 0)
    model.addConstr(11 * x1 + 15 * x3 <= 75)
    model.addConstr(9 * x2 + 15 * x3 <= 120)
    model.addConstr(11 * x1 + 9 * x2 + 15 * x3 <= 120)

    # Set bounds for defensive capability ratings
    model.addConstr(x1 <= 135 / 11, name='r0_x1')
    model.addConstr(x2 <= 135 / 9, name='r0_x2')
    model.addConstr(x3 <= 135 / 15, name='r0_x3')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Armored companies: {x1.varValue}")
        print(f"Airborne infantry companies: {x2.varValue}")
        print(f"Air defense batteries: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
