
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0")  # milligrams of vitamin B9
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # milligrams of iron
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2")  # grams of fat
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin K


    # Set objective function
    obj = 3.5*x0**2 + 9.34*x0*x1 + 5.49*x0*x2 + 1.94*x0*x3 + 2.34*x1*x2 + 5.97*x1*x3 + 5.31*x2**2 + 6.81*x0 + 3.88*x1 + 9.01*x2 + 9.61*x3
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.07*x0 + 1.07*x1 + 0.62*x2 + 1.58*x3 <= 124, "c0")
    m.addConstr(0.41*x0 + 0.09*x1 + 1.83*x2 + 1.46*x3 <= 92, "c1")
    m.addConstr(0.62*x2**2 + 1.58*x3**2 >= 24, "c2")
    m.addConstr(1.07*x0 + 0.62*x2 >= 25, "c3")
    m.addConstr(1.07*x0 + 1.07*x1 + 0.62*x2 >= 22, "c4")
    m.addConstr(1.07*x0**2 + 1.07*x1**2 + 0.62*x2**2 >= 22, "c5")
    m.addConstr(1.07*x0**2 + 1.07*x1**2 + 0.62*x2**2 >= 30, "c6")
    m.addConstr(1.07*x1**2 + 0.62*x2**2 + 1.58*x3**2 >= 30, "c7")
    m.addConstr(1.07*x0 + 1.07*x1 + 0.62*x2 + 1.58*x3 >= 30, "c8")
    m.addConstr(1.83*x2 + 1.46*x3 >= 16, "c9")
    m.addConstr(0.09*x1 + 1.83*x2 >= 19, "c10")
    m.addConstr(0.41*x0 + 1.83*x2 + 1.46*x3 >= 15, "c11")
    m.addConstr(0.41*x0 + 0.09*x1 + 1.83*x2 + 1.46*x3 >= 15, "c12")
    m.addConstr(9*x1 - 9*x2 >= 0, "c13")
    m.addConstr(4*x2**2 - 2*x3**2 >= 0, "c14")
    m.addConstr(-3*x1 + 5*x3 >= 0, "c15")
    m.addConstr(0.41*x0**2 + 0.09*x1**2 + 1.83*x2**2 <= 24, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
