
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B9
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of iron
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # grams of fat
    x4 = model.addVar(name="x4")  # milligrams of vitamin K

    # Objective function
    model.setObjective(3.5 * x1**2 + 9.34 * x1 * x2 + 5.49 * x1 * x3 + 1.94 * x1 * x4 + 
                       2.34 * x2 * x3 + 5.97 * x2 * x4 + 5.31 * x3**2 + 6.81 * x1 + 
                       3.88 * x2 + 9.01 * x3 + 9.61 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.07 * x1 <= 124)
    model.addConstr(0.41 * x1 <= 92)
    model.addConstr(1.07 * x2 <= 124)
    model.addConstr(0.09 * x2 <= 92)
    model.addConstr(0.62 * x3 <= 124)
    model.addConstr(1.83 * x3 <= 92)
    model.addConstr(1.58 * x4 <= 124)
    model.addConstr(1.46 * x4 <= 92)
    model.addConstr(0.62 * x3**2 + 1.58 * x4**2 >= 24)
    model.addConstr(1.07 * x1 + 0.62 * x3 >= 25)
    model.addConstr(1.07 * x1 + 1.07 * x2 + 0.62 * x3 >= 22)
    model.addConstr(1.07 * x2**2 + 0.62 * x3**2 + 1.58 * x4**2 >= 22)
    model.addConstr(1.07 * x1**2 + 1.07 * x2**2 + 0.62 * x3**2 >= 30)
    model.addConstr(1.07 * x2**2 + 0.62 * x3**2 + 1.58 * x4**2 >= 30)
    model.addConstr(x1 + x2 + x3 + x4 >= 30)
    model.addConstr(1.83 * x3 + 1.46 * x4 >= 16)
    model.addConstr(0.09 * x2 + 1.83 * x3 >= 19)
    model.addConstr(0.41 * x1 + 1.83 * x3 + 1.46 * x4 >= 15)
    model.addConstr(0.41 * x1 + 0.09 * x2 + 1.83 * x3 + 1.46 * x4 >= 15)
    model.addConstr(9 * x2 - 9 * x3 >= 0)
    model.addConstr(4 * x3**2 - 2 * x4**2 >= 0)
    model.addConstr(-3 * x2 + 5 * x4 >= 0)
    model.addConstr(0.41**2 * x1**2 + 0.09**2 * x2**2 + 1.83**2 * x3**2 <= 24)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No solution found")

optimization_problem()
