
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_iron")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_C")


    # Set objective function
    m.setObjective(3.28*x0**2 + 7.16*x1**2 + 6.45*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16*x0 + 22*x1 >= 28, "kidney_support_1")
    m.addConstr(9*x0 + 6*x1 >= 25, "digestive_support_1")
    m.addConstr(5*x0 + 5*x1 >= 30, "cognitive_performance_1")
    m.addConstr(25*x0 + 24*x1 >= 98, "cardiovascular_support_1")
    m.addConstr(-9*x0**2 + 7*x1**2 >= 0, "quadratic_constraint")
    m.addConstr(16*x0 + 22*x1 <= 71, "kidney_support_2")
    m.addConstr(9*x0 + 6*x1 <= 89, "digestive_support_2")
    m.addConstr(5*x0 + 5*x1 <= 68, "cognitive_performance_2")
    m.addConstr(25*x0 + 24*x1 <= 165, "cardiovascular_support_2")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams_of_iron:', x0.x)
        print('milligrams_of_vitamin_C:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
