
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_iron", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_C", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3.28*x1**2 + 7.16*x2**2 + 6.45*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x1 <= 79, name="kidney_support_index_iron")
m.addConstr(9*x1 <= 120, name="digestive_support_index_iron")
m.addConstr(5*x1 <= 132, name="cognitive_performance_index_iron")
m.addConstr(25*x1 <= 207, name="cardiovascular_support_index_iron")

m.addConstr(22*x2 <= 79, name="kidney_support_index_vitamin_C")
m.addConstr(6*x2 <= 120, name="digestive_support_index_vitamin_C")
m.addConstr(5*x2 <= 132, name="cognitive_performance_index_vitamin_C")
m.addConstr(24*x2 <= 207, name="cardiovascular_support_index_vitamin_C")

m.addConstr(16*x1 + 22*x2 >= 28, name="combined_kidney_support_index")
m.addConstr(9*x1 + 6*x2 >= 25, name="combined_digestive_support_index")
m.addConstr(5*x1 + 5*x2 >= 30, name="combined_cognitive_performance_index")
m.addConstr(25*x1 + 24*x2 >= 98, name="combined_cardiovascular_support_index")

m.addConstr(-9*x1**2 + 7*x2**2 >= 0, name="quadratic_constraint")

m.addConstr(16*x1 + 22*x2 <= 71, name="upper_bound_combined_kidney_support_index")
m.addConstr(9*x1 + 6*x2 <= 89, name="upper_bound_combined_digestive_support_index")
m.addConstr(5*x1 + 5*x2 <= 68, name="upper_bound_combined_cognitive_performance_index")
m.addConstr(25*x1 + 24*x2 <= 165, name="upper_bound_combined_cardiovascular_support_index")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {x1.varValue}")
    print(f"Milligrams of vitamin C: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
