
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="chicken_drumsticks")
    x1 = m.addVar(vtype=GRB.INTEGER, name="cornichons")
    x2 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")


    # Set objective function
    m.setObjective(8*x0 + 1*x1 + 7*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 17*x1 >= 37, "iron_constraint1")
    m.addConstr(17*x1 + 16*x2 >= 26, "iron_constraint2")
    m.addConstr(14*x0 + 17*x1 + 16*x2 >= 26, "iron_constraint3")
    m.addConstr(3*x0 + 10*x1 >= 103, "carbohydrate_constraint1")
    m.addConstr(3*x0 + 4*x2 >= 81, "carbohydrate_constraint2")
    m.addConstr(10*x1 + 4*x2 >= 69, "carbohydrate_constraint3")
    m.addConstr(3*x0 + 10*x1 + 4*x2 >= 69, "carbohydrate_constraint4")
    m.addConstr(1*x1 - 5*x2 >= 0, "constraint7")
    m.addConstr(10*x0 - 7*x2 >= 0, "constraint8")
    m.addConstr(6*x0 - 3*x1 >= 0, "constraint9")
    m.addConstr(17*x1 + 16*x2 <= 153, "constraint10")
    m.addConstr(10*x1 + 4*x2 <= 293, "constraint11")

    # Resource Constraints
    m.addConstr(14*x0 + 17*x1 + 16*x2 <= 186, "iron_resource_constraint")
    m.addConstr(3*x0 + 10*x1 + 4*x2 <= 431, "carbohydrate_resource_constraint")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('chicken drumsticks:', x0.x)
        print('cornichons:', x1.x)
        print('corn cobs:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
