
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_thighs")

# Set objective function
m.setObjective(4*x0 + 8*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 21*x1 + 17*x2 <= 283, "dollar_cost")
m.addConstr(10*x0 + 6*x1 + 13*x2 <= 368, "carbohydrates")
m.addConstr(6*x1 + 13*x2 >= 41, "carbs_hotdogs_thighs")
m.addConstr(10*x0 + 13*x2 >= 44, "carbs_chickens_thighs")
m.addConstr(10*x0 + 6*x1 >= 86, "carbs_chickens_hotdogs")
m.addConstr(2*x0 + 21*x1 <= 205, "dollars_chickens_hotdogs")
m.addConstr(21*x1 + 17*x2 <= 180, "dollars_hotdogs_thighs")
m.addConstr(2*x0 + 21*x1 + 17*x2 <= 107, "dollars_total1")
m.addConstr(6*x1 + 13*x2 <= 333, "carbs_hotdogs_thighs_upper")
m.addConstr(10*x0 + 6*x1 + 13*x2 <= 157, "carbs_total")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('rotisserie_chickens:', x0.x)
    print('hot_dogs:', x1.x)
    print('chicken_thighs:', x2.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

