
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="hot_dogs", vtype=gurobi.GRB.CONTINUOUS, lb=0)
    x3 = model.addVar(name="chicken_thighs", vtype=gurobi.GRB.CONTINUOUS, lb=0)

    # Objective function
    model.setObjective(4*x1 + 8*x2 + 7*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 21*x2 + 17*x3 <= 283)
    model.addConstr(10*x1 + 6*x2 + 13*x3 <= 368)
    model.addConstr(6*x2 + 13*x3 >= 41)
    model.addConstr(10*x1 + 13*x3 >= 44)
    model.addConstr(10*x1 + 6*x2 >= 86)
    model.addConstr(2*x1 + 21*x2 <= 205)
    model.addConstr(21*x2 + 17*x3 <= 180)
    model.addConstr(2*x1 + 21*x2 + 17*x3 <= 107)
    model.addConstr(6*x2 + 13*x3 <= 333)
    model.addConstr(10*x1 + 6*x2 + 13*x3 <= 157)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Rotisserie Chickens: ", x1.varValue)
        print("Hot Dogs: ", x2.varValue)
        print("Chicken Thighs: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
