
import gurobipy as gp

# Create a new model
model = gp.Model("Resource_Allocation")

# Create variables
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")


# Set objective function
model.setObjective(7.06 * mary + 2.55 * laura + 2.83 * george + 8.09 * john + 2.0 * jean + 1.26 * bill + 1.11 * paul, gp.GRB.MAXIMIZE)

# Add constraints

r0_paperwork = model.addConstr(16 * mary + 6 * laura + 9 * george + 10 * john + 15 * jean + 3 * bill + 1 * paul <= 385, "r0_paperwork")
r1_computer = model.addConstr(15 * mary + 16 * laura + 1 * george + 6 * john + 12 * jean + 4 * bill + 17 * paul <= 304, "r1_computer")
r2_organization = model.addConstr(2 * mary + 5 * laura + 2 * george + 10 * john + 14 * jean + 14 * bill + 1 * paul <= 349, "r2_organization")


# Add other constraints from the input
model.addConstr(6 * laura + 10 * john >= 26)
model.addConstr(9 * george + 1 * paul >= 46)
model.addConstr(15 * jean + 1 * paul >= 32)
model.addConstr(16 * mary + 10 * john >= 45)
model.addConstr(16 * mary + 6 * laura >= 43)
model.addConstr(16 * mary + 15 * jean >= 19)
model.addConstr(6 * laura + 3 * bill >= 54)
model.addConstr(6 * laura + 1 * paul >= 53)
model.addConstr(3 * bill + 1 * paul >= 35)
model.addConstr(16 * mary + 9 * george >= 55)
model.addConstr(10 * john + 1 * paul >= 21)
model.addConstr(10 * john + 3 * bill >= 32)
model.addConstr(6 * laura + 15 * jean >= 51)
# ... (add all remaining constraints similarly)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

