
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrient_optimization")

    # Create variables
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
    vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
    vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")

    # Set objective function
    m.setObjective(2*calcium + 4*magnesium + 9*vitamin_b3 + 3*vitamin_b1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*calcium + 4*magnesium + 6*vitamin_b3 >= 18)
    m.addConstr(calcium + 3*vitamin_b1 >= 45)
    m.addConstr(calcium + 5*magnesium + 5*vitamin_b3 >= 35)
    m.addConstr(calcium + 5*vitamin_b3 + 3*vitamin_b1 >= 35)
    m.addConstr(calcium + 5*magnesium + 5*vitamin_b3 >= 29)
    m.addConstr(calcium + 5*vitamin_b3 + 3*vitamin_b1 >= 29)
    m.addConstr(7*calcium - magnesium >= 0)
    m.addConstr(4*calcium - 10*vitamin_b3 + 2*vitamin_b1 >= 0)
    m.addConstr(6*vitamin_b3 + 5*vitamin_b1 <= 119)
    m.addConstr(4*magnesium + 6*vitamin_b3 <= 74)
    m.addConstr(8*calcium + 4*magnesium + 6*vitamin_b3 <= 93)
    m.addConstr(8*calcium + 4*magnesium + 5*vitamin_b1 <= 119)
    m.addConstr(4*magnesium + 6*vitamin_b3 + 5*vitamin_b1 <= 42)
    m.addConstr(8*calcium + 4*magnesium + 6*vitamin_b3 + 5*vitamin_b1 <= 42)
    m.addConstr(7*magnesium + 7*vitamin_b1 <= 125)
    m.addConstr(2*calcium + 7*vitamin_b1 <= 191)
    m.addConstr(2*calcium + 7*vitamin_b3 + 7*vitamin_b1 <= 73)
    m.addConstr(2*calcium + 7*magnesium + 7*vitamin_b3 + 7*vitamin_b1 <= 73)
    m.addConstr(11*vitamin_b3 + vitamin_b1 <= 44)
    m.addConstr(9*magnesium + 11*vitamin_b3 <= 70)
    m.addConstr(9*magnesium + vitamin_b1 <= 76)
    m.addConstr(9*calcium + 9*magnesium + 11*vitamin_b3 + vitamin_b1 <= 76)
    m.addConstr(5*magnesium + 5*vitamin_b3 <= 105)
    m.addConstr(calcium + 5*vitamin_b3 <= 168)
    m.addConstr(calcium + 3*vitamin_b1 <= 86)
    m.addConstr(calcium + 5*magnesium <= 127)
    m.addConstr(calcium + 5*magnesium + 5*vitamin_b3 + 3*vitamin_b1 <= 127)


    # Resource Constraints (provided in the CONTEXT section)
    m.addConstr(8*calcium + 4*magnesium + 6*vitamin_b3 + 5*vitamin_b1 <= 120)  # r0: immune support
    m.addConstr(2*calcium + 7*magnesium + 7*vitamin_b3 + 7*vitamin_b1 <= 208)  # r1: digestive support
    m.addConstr(9*calcium + 9*magnesium + 11*vitamin_b3 + 1*vitamin_b1 <= 92)  # r2: muscle growth
    m.addConstr(1*calcium + 5*magnesium + 5*vitamin_b3 + 3*vitamin_b1 <= 191)  # r3: energy stability


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('calcium:', calcium.x)
        print('magnesium:', magnesium.x)
        print('vitamin_b3:', vitamin_b3.x)
        print('vitamin_b1:', vitamin_b1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
