
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B6
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # milligrams of iron


    # Set objective function
    m.setObjective(4.56 * x0 + 4.11 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20 * x0 + 18 * x1 >= 20, "c0")
    m.addConstr(20 * x0 + 25 * x1 >= 25, "c1")
    m.addConstr(19 * x0 + 9 * x1 >= 15, "c2")
    m.addConstr(24 * x0 + 26 * x1 >= 30, "c3")
    m.addConstr(26 * x0 + 16 * x1 >= 45, "c4")
    m.addConstr(x0 - x1 >= 0, "c5")
    m.addConstr(20 * x0 + 18 * x1 <= 40, "c6")
    m.addConstr(20 * x0 + 25 * x1 <= 37, "c7")
    m.addConstr(19 * x0 + 9 * x1 <= 88, "c8")
    m.addConstr(24 * x0 + 26 * x1 <= 108, "c9")
    m.addConstr(26 * x0 + 16 * x1 <= 77, "c10")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Something went wrong.")

except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

