
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams of vitamin B6", lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="milligrams of iron", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4.56 * x1 + 4.11 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 18 * x2 >= 20, name="kidney_support_index_min")
    model.addConstr(20 * x1 + 25 * x2 >= 25, name="immune_support_index_min")
    model.addConstr(19 * x1 + 9 * x2 >= 15, name="energy_stability_index_min")
    model.addConstr(24 * x1 + 26 * x2 >= 30, name="muscle_growth_index_min")
    model.addConstr(26 * x1 + 16 * x2 >= 45, name="cognitive_performance_index_min")
    model.addConstr(x1 - x2 >= 0, name="vitamin_B6_vs_iron")
    model.addConstr(20 * x1 + 18 * x2 <= 40, name="kidney_support_index_max")
    model.addConstr(20 * x1 + 25 * x2 <= 37, name="immune_support_index_max")
    model.addConstr(19 * x1 + 9 * x2 <= 88, name="energy_stability_index_max")
    model.addConstr(24 * x1 + 26 * x2 <= 108, name="muscle_growth_index_max")
    model.addConstr(26 * x1 + 16 * x2 <= 77, name="cognitive_performance_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B6: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
