
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, name=["John", "Jean", "Ringo", "Laura"], vtype=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(3*x[0] + 2*x[1] + 5*x[2] + 3*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1.35*x[0] + 4.5*x[1] + 0.1*x[2] >= 32)
    m.addConstr(1.79*x[0] + 0.91*x[1] + 0.67*x[3] >= 38)
    m.addConstr(1.79*x[0] + 0.91*x[1] + 1.89*x[2] >= 38)
    m.addConstr(1.79*x[0] + 0.91*x[1] + 0.67*x[3] >= 51)
    m.addConstr(1.79*x[0] + 0.91*x[1] + 1.89*x[2] >= 51)
    m.addConstr(4.5*x[1] + 3.92*x[3] <= 104)
    m.addConstr(1.35*x[0] + 4.5*x[1] <= 59)
    m.addConstr(1.35*x[0] + 3.92*x[3] <= 81)
    m.addConstr(1.35*x[0] + 4.5*x[1] + 3.92*x[3] <= 142)
    m.addConstr(1.35*x[0] + 4.5*x[1] + 0.1*x[2] <= 83)
    m.addConstr(1.35*x[0] + 4.5*x[1] + 0.1*x[2] + 3.92*x[3] <= 83)
    m.addConstr(1.79*x[0] + 1.89*x[2] <= 173)
    m.addConstr(1.89*x[2] + 0.67*x[3] <= 150)
    m.addConstr(0.91*x[1] + 1.89*x[2] <= 190)
    m.addConstr(0.91*x[1] + 0.67*x[3] <= 98)
    m.addConstr(1.79*x[0] + 0.91*x[1] + 1.89*x[2] + 0.67*x[3] <= 98)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
