
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by John
x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura

# Objective function
model.setObjective(3*x0 + 2*x1 + 5*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(1.35*x0 + 4.5*x1 + 0.1*x2 >= 32)
model.addConstr(1.79*x0 + 0.91*x1 + 0.67*x3 >= 38)
model.addConstr(1.79*x0 + 0.91*x1 + 1.89*x2 >= 38)
model.addConstr(1.79*x0 + 0.91*x1 + 0.67*x3 >= 51)
model.addConstr(1.79*x0 + 0.91*x1 + 1.89*x2 >= 51)
model.addConstr(4.5*x1 + 3.92*x3 <= 104)
model.addConstr(1.35*x0 + 4.5*x1 <= 59)
model.addConstr(1.35*x0 + 3.92*x3 <= 81)
model.addConstr(1.35*x0 + 4.5*x1 + 3.92*x3 <= 142)
model.addConstr(1.35*x0 + 4.5*x1 + 0.1*x2 <= 83)
model.addConstr(1.35*x0 + 4.5*x1 + 0.1*x2 + 3.92*x3 <= 83)
model.addConstr(1.79*x0 + 1.89*x2 <= 173)
model.addConstr(1.89*x2 + 0.67*x3 <= 150)
model.addConstr(0.91*x1 + 1.89*x2 <= 190)
model.addConstr(0.91*x1 + 0.67*x3 <= 98)
model.addConstr(1.79*x0 + 0.91*x1 + 1.89*x2 + 0.67*x3 <= 98)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
