
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")  # Integer
    zinc = m.addVar(vtype=gp.GRB.CONTINUOUS, name="zinc")  # Continuous

    # Set objective function
    m.setObjective(1 * vitamin_d + 7 * zinc, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * vitamin_d + 1 * zinc >= 14, "cardiovascular_support_min")
    m.addConstr(7 * vitamin_d + 2 * zinc >= 24, "immune_support_min")
    m.addConstr(-7 * vitamin_d + 9 * zinc >= 0, "constraint_3")
    m.addConstr(7 * vitamin_d + 1 * zinc <= 26, "cardiovascular_support_max")
    m.addConstr(7 * vitamin_d + 2 * zinc <= 32, "immune_support_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Milligrams of Vitamin D: {vitamin_d.x}")
        print(f"Milligrams of Zinc: {zinc.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

