
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_D")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_zinc", lb=0)

# Set the objective function
m.setObjective(1*x0 + 7*x1, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(7*x0 + x1 >= 14, "cardiovascular_support_index_min")
m.addConstr(7*x0 + 2*x1 >= 24, "immune_support_index_min")
m.addConstr(-7*x0 + 9*x1 >= 0, "vitamin_d_zinc_constraint")
m.addConstr(7*x0 + x1 <= 26, "cardiovascular_support_index_max")
m.addConstr(7*x0 + 2*x1 <= 32, "immune_support_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Milligrams of Vitamin D:", x0.x)
    print("Milligrams of Zinc:", x1.x)
else:
    print("No optimal solution found")
