
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=1, vtype=gurobi.GRB.INTEGER, name="x1")  # milligrams of vitamin D
x2 = model.addVar(lb=1, name="x2")  # milligrams of zinc

# Set the objective function
model.setObjective(x1 + 7 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * x1 + x2 >= 14, name="cardiovascular_support")
model.addConstr(7 * x1 + 2 * x2 >= 24, name="immune_support")
model.addConstr(-7 * x1 + 9 * x2 >= 0, name="zinc_vs_vitaminD")
model.addConstr(7 * x1 + x2 <= 26, name="cardiovascular_upper_bound")
model.addConstr(7 * x1 + 2 * x2 <= 32, name="immune_upper_bound")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin D: {x1.varValue}")
    print(f"Milligrams of zinc: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
