
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")


    # Set objective function
    m.setObjective(1*x0 + 9*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x1 + 6*x2 >= 39, "c0")
    m.addConstr(6*x0 + 12*x1 >= 43, "c1")
    m.addConstr(17*x0 + 12*x1 + 21*x2 >= 30, "c2")
    m.addConstr(6*x0 + 6*x2 <= 124, "c3")
    m.addConstr(12*x1 + 6*x2 <= 119, "c4")
    m.addConstr(6*x0 + 12*x1 + 6*x2 <= 119, "c5")
    m.addConstr(17*x0 + 21*x2 <= 76, "c6")
    m.addConstr(17*x0 + 12*x1 <= 70, "c7")
    m.addConstr(17*x0 + 12*x1 + 21*x2 <= 70, "c8")

    # Resource Constraints
    m.addConstr(6*x0 <= 145, "iron_chicken")
    m.addConstr(12*x1 <= 145, "iron_cornichons")
    m.addConstr(6*x2 <= 145, "iron_pizza")
    m.addConstr(17*x0 <= 159, "fiber_chicken")
    m.addConstr(12*x1 <= 159, "fiber_cornichons")
    m.addConstr(21*x2 <= 159, "fiber_pizza")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
