
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="chicken_breasts", lb=0)
    x1 = model.addVar(name="cornichons", lb=0)
    x2 = model.addVar(name="slices_of_pizza", lb=0)

    # Define the objective function
    model.setObjective(1 * x0 + 9 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 12 * x1 + 6 * x2 <= 145)
    model.addConstr(17 * x0 + 12 * x1 + 21 * x2 <= 159)
    model.addConstr(12 * x1 + 6 * x2 >= 39)
    model.addConstr(6 * x0 + 12 * x1 >= 43)
    model.addConstr(17 * x0 + 12 * x1 + 21 * x2 >= 30)
    model.addConstr(6 * x0 + 6 * x2 <= 124)
    model.addConstr(12 * x1 + 6 * x2 <= 119)
    model.addConstr(6 * x0 + 12 * x1 + 6 * x2 <= 119)
    model.addConstr(17 * x0 + 21 * x2 <= 76)
    model.addConstr(17 * x0 + 12 * x1 <= 70)
    model.addConstr(17 * x0 + 12 * x1 + 21 * x2 <= 70)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Chicken breasts: ", x0.varValue)
        print("Cornichons: ", x1.varValue)
        print("Slices of pizza: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
