
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Work_Hours")

# Create variables
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
john = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="John")
peggy = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Peggy")


# Set objective function
model.setObjective(5.89 * mary + 7.14 * hank + 7.41 * george + 9.4 * john + 6.98 * peggy, gp.GRB.MINIMIZE)

# Resource coefficients
paperwork_competence = [16, 9, 18, 5, 17]
organization_score = [6, 21, 27, 22, 17]
work_quality = [3, 22, 22, 1, 11]
computer_competence = [16, 15, 25, 19, 4]
productivity = [13, 11, 25, 6, 4]

variables = [mary, hank, george, john, peggy]

# Add constraints
model.addConstr(18 * george + 17 * peggy >= 24)
model.addConstr(5 * john + 17 * peggy >= 30)
model.addConstr(16 * mary + 5 * john >= 13)
model.addConstr(16 * mary + 18 * george >= 24)
model.addConstr(9 * hank + 18 * george >= 36)


# ... (rest of the constraints from the JSON "constraints" section)

model.addConstr(2 * mary - 9 * george >= 0)
model.addConstr(10 * mary - 3 * hank >= 0)

# ... (rest of the constraints from the JSON "constraints" section)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

