
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")
x4 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_John")  # Whole number
x5 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Peggy")  # Whole number

# Placeholder objective function: Minimize the total hours worked
m.setObjective(x1 + x2 + x3 + x4 + x5, GRB.MINIMIZE)

# Add constraints as examples:
# - The constraint: 2 times the number of hours worked by Mary, plus minus nine times the number of hours worked by George has to be at minimum zero.
m.addConstr(2*x1 - 9*x3 >= 0, "Mary_George_Constraint")

# - The constraint: 10 times the number of hours worked by Mary, plus -3 times the number of hours worked by Hank must be at minimum zero.
m.addConstr(10*x1 - 3*x2 >= 0, "Mary_Hank_Constraint")

# - Adding more constraints based on the problem description...
# For each constraint in the problem description, add a corresponding line here.

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
