
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Mary", lb=0)
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)
x3 = m.addVar(name="hours_worked_by_George", lb=0)
x4 = m.addVar(name="hours_worked_by_John", lb=0, integrality=gp.GRB.INTEGER)
x5 = m.addVar(name="hours_worked_by_Peggy", lb=0, integrality=gp.GRB.INTEGER)

# Objective function
m.setObjective(5.89*x1 + 7.14*x2 + 7.41*x3 + 9.4*x4 + 6.98*x5, gp.GRB.MINIMIZE)

# Constraints
# Individual ratings
m.addConstr(16*x1 >= 16)
m.addConstr(6*x1 >= 6)
m.addConstr(3*x1 >= 3)
m.addConstr(16*x1 >= 16)
m.addConstr(13*x1 >= 13)

m.addConstr(9*x2 >= 9)
m.addConstr(21*x2 >= 21)
m.addConstr(22*x2 >= 22)
m.addConstr(15*x2 >= 15)
m.addConstr(11*x2 >= 11)

m.addConstr(18*x3 >= 18)
m.addConstr(27*x3 >= 27)
m.addConstr(22*x3 >= 22)
m.addConstr(25*x3 >= 25)
m.addConstr(25*x3 >= 25)

m.addConstr(5*x4 >= 5)
m.addConstr(22*x4 >= 22)
m.addConstr(x4 >= 1)
m.addConstr(19*x4 >= 19)
m.addConstr(6*x4 >= 6)

m.addConstr(17*x5 >= 17)
m.addConstr(17*x5 >= 17)
m.addConstr(11*x5 >= 11)
m.addConstr(4*x5 >= 4)
m.addConstr(4*x5 >= 4)

# Combined paperwork competence rating
m.addConstr(18*x3 + 17*x5 >= 24)
m.addConstr(5*x4 + 17*x5 >= 30)
m.addConstr(16*x1 + 5*x4 >= 13)
m.addConstr(16*x1 + 18*x3 >= 24)
m.addConstr(9*x2 + 18*x3 >= 36)
m.addConstr(16*x1 + 9*x2 + 5*x4 >= 19)
m.addConstr(16*x1 + 5*x4 + 17*x5 >= 19)
m.addConstr(18*x3 + 5*x4 + 17*x5 >= 19)
m.addConstr(16*x1 + 18*x3 + 5*x4 >= 19)
m.addConstr(16*x1 + 9*x2 + 17*x5 >= 19)
m.addConstr(16*x1 + 18*x3 + 17*x5 >= 19)

# ... (rest of the constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by George: ", x3.varValue)
    print("Hours worked by John: ", x4.varValue)
    print("Hours worked by Peggy: ", x5.varValue)
else:
    print("No optimal solution found")
