
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    calcium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")
    vitamin_e = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_e")


    # Set objective function
    m.setObjective(4 * calcium + 5 * vitamin_e, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(23 * calcium + 1 * vitamin_e >= 12, "c1")
    m.addConstr(22 * calcium + 7 * vitamin_e >= 48, "c2")
    m.addConstr(1 * calcium + 21 * vitamin_e >= 43, "c3")
    m.addConstr(26 * calcium + 6 * vitamin_e >= 7, "c4")
    m.addConstr(6 * calcium - 3 * vitamin_e >= 0, "c5")
    m.addConstr(23 * calcium + 1 * vitamin_e <= 38, "c6")
    m.addConstr(22 * calcium + 7 * vitamin_e <= 66, "c7")
    m.addConstr(1 * calcium + 21 * vitamin_e <= 81, "c8")
    m.addConstr(26 * calcium + 6 * vitamin_e <= 31, "c9")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

