
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_calcium")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")

# Set the objective function
m.setObjective(4*x0 + 5*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(23*x0 + x1 >= 12, "cardiovascular_support_index_min")
m.addConstr(23*x0 + x1 <= 38, "cardiovascular_support_index_max")
m.addConstr(22*x0 + 7*x1 >= 48, "muscle_growth_index_min")
m.addConstr(22*x0 + 7*x1 <= 66, "muscle_growth_index_max")
m.addConstr(x0 + 21*x1 >= 43, "cognitive_performance_index_min")
m.addConstr(x0 + 21*x1 <= 81, "cognitive_performance_index_max")
m.addConstr(26*x0 + 6*x1 >= 7, "immune_support_index_min")
m.addConstr(26*x0 + 6*x1 <= 31, "immune_support_index_max")
m.addConstr(6*x0 - 3*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Calcium: {x0.x}")
    print(f"Milligrams of Vitamin E: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
