
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_calcium", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="milligrams_of_vitamin_E", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(23 * x1 + x2 >= 12, name="cardiovascular_support_index_min")
    model.addConstr(22 * x1 + 7 * x2 >= 48, name="muscle_growth_index_min")
    model.addConstr(x1 + 21 * x2 >= 43, name="cognitive_performance_index_min")
    model.addConstr(26 * x1 + 6 * x2 >= 7, name="immune_support_index_min")
    model.addConstr(6 * x1 - 3 * x2 >= 0, name="calcium_vitamin_E_balance")
    model.addConstr(23 * x1 + x2 <= 38, name="cardiovascular_support_index_max")
    model.addConstr(22 * x1 + 7 * x2 <= 66, name="muscle_growth_index_max")
    model.addConstr(x1 + 21 * x2 <= 81, name="cognitive_performance_index_max")
    model.addConstr(26 * x1 + 6 * x2 <= 31, name="immune_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin E: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
