
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B2
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of calcium
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin D


    # Set objective function
    m.setObjective(7*x0**2 + 7*x0*x1 + 1*x1**2 + 3*x2**2 + 6*x0, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1.8*x0 + 13.5*x1 + 9.2*x2 <= 164, "r0")
    m.addConstr(14.76*x0 + 10.92*x1 + 13.51*x2 <= 300, "r1")
    m.addConstr(1.8*x0**2 + 9.2*x2**2 >= 32, "c1")
    m.addConstr(13.5*x1**2 + 9.2*x2**2 >= 54, "c2")
    m.addConstr(1.8*x0**2 + 13.5*x1**2 >= 19, "c3")
    m.addConstr(10.92*x1 + 13.51*x2 >= 76, "c4")
    m.addConstr(14.76*x0**2 + 13.51*x2**2 >= 44, "c5")
    m.addConstr(1.8*x0 + 13.5*x1 <= 88, "c6")
    m.addConstr(1.8*x0**2 + 9.2*x2**2 <= 158, "c7")
    m.addConstr(1.8*x0**2 + 13.5*x1**2 + 9.2*x2**2 <= 111, "c8")
    m.addConstr(1.8*x0 + 13.5*x1 + 9.2*x2 <= 111, "c9")
    m.addConstr(14.76*x0**2 + 13.51*x2**2 <= 152, "c10")
    m.addConstr(10.92*x1 + 13.51*x2 <= 100, "c11")
    m.addConstr(14.76*x0 + 10.92*x1 + 13.51*x2 <= 100, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
