
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(7*x1**2 + 7*x1*x2 + x2**2 + 3*x3**2 + 6*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.8*x1 <= 164)
    model.addConstr(14.76*x1 <= 300)
    model.addConstr(13.5*x2 <= 164)
    model.addConstr(10.92*x2 <= 300)
    model.addConstr(9.2*x3 <= 164)
    model.addConstr(13.51*x3 <= 300)
    model.addConstr(3.24*x1**2 + 84.64*x3**2 >= 32)
    model.addConstr(182.25*x2**2 + 84.64*x3**2 >= 54)
    model.addConstr(3.24*x1**2 + 182.25*x2**2 >= 19)
    model.addConstr(10.92*x2 + 13.51*x3 >= 76)
    model.addConstr(217.4976*x1**2 + 182.4201*x3**2 >= 44)
    model.addConstr(1.8*x1 + 13.5*x2 <= 88)
    model.addConstr(3.24*x1**2 + 84.64*x3**2 <= 158)
    model.addConstr(3.24*x1**2 + 182.25*x2**2 + 84.64*x3**2 <= 111)
    model.addConstr(1.8*x1 + 13.5*x2 + 9.2*x3 <= 111)
    model.addConstr(217.4976*x1**2 + 182.4201*x3**2 <= 152)
    model.addConstr(10.92*x2 + 13.51*x3 <= 100)
    model.addConstr(14.76*x1 + 10.92*x2 + 13.51*x3 <= 100)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
