
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")
milk = m.addVar(vtype=gp.GRB.INTEGER, name="cartons_of_milk")
paper_towels = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")


# Set objective function
m.setObjective(7 * diapers + 8 * candles + 9 * cookies + 5 * milk + 6 * paper_towels, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * diapers + 18 * milk + 1 * paper_towels >= 52)
m.addConstr(4 * candles + 13 * cookies + 18 * milk >= 52)
m.addConstr(10 * diapers + 4 * candles + 13 * cookies >= 52)
m.addConstr(4 * candles + 13 * cookies + 1 * paper_towels >= 52)
m.addConstr(10 * diapers + 4 * candles + 1 * paper_towels >= 52)
m.addConstr(10 * diapers + 4 * candles + 18 * milk >= 52)
# ... (rest of the value constraints)

m.addConstr(9 * diapers + 11 * milk >= 24)
m.addConstr(9 * diapers + 2 * candles >= 31)
m.addConstr(2 * candles + 19 * paper_towels >= 30)
m.addConstr(9 * diapers + 19 * paper_towels >= 33)
m.addConstr(4 * cookies + 11 * milk >= 37)
# ... (rest of the usefulness constraints)


m.addConstr(10 * diapers + 13 * cookies <= 108)
m.addConstr(10 * diapers + 4 * candles <= 139)
m.addConstr(10 * diapers + 4 * candles + 13 * cookies + 18 * milk + 1 * paper_towels <= 139)
# ... (rest of the upper bound constraints)

m.addConstr(10 * diapers + 4 * candles + 13 * cookies + 18 * milk + paper_towels <= 266)
m.addConstr(9 * diapers + 2 * candles + 4 * cookies + 11 * milk + 19 * paper_towels <= 249)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

