
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
laura = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura")
paul = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
mary = m.addVar(lb=0, vtype=GRB.INTEGER, name="Mary")
bill = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill")
john = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="John")


# Set objective function
m.setObjective(4.18 * laura + 4.81 * paul + 7.49 * mary + 5.02 * bill + 9.16 * john, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.22 * laura + 6.0 * bill >= 55)
m.addConstr(4.22 * laura + 6.81 * john >= 33)
m.addConstr(4.27 * mary + 6.81 * john >= 45)
m.addConstr(4.22 * laura + 4.27 * mary >= 37)
m.addConstr(7.07 * paul + 4.27 * mary >= 39)
m.addConstr(7.07 * paul + 6.0 * bill + 6.81 * john >= 49)
m.addConstr(4.27 * mary + 6.0 * bill + 6.81 * john >= 49)
m.addConstr(7.07 * paul + 4.27 * mary + 6.81 * john >= 49)
m.addConstr(7.07 * paul + 6.0 * bill + 6.81 * john >= 54)
m.addConstr(4.27 * mary + 6.0 * bill + 6.81 * john >= 54)
m.addConstr(7.07 * paul + 4.27 * mary + 6.81 * john >= 54)
m.addConstr(7.07 * paul + 6.0 * bill + 6.81 * john >= 58)
m.addConstr(4.27 * mary + 6.0 * bill + 6.81 * john >= 58)
m.addConstr(7.07 * paul + 4.27 * mary + 6.81 * john >= 58)
m.addConstr(4.22 * laura + 7.07 * paul + 4.27 * mary + 6.0 * bill + 6.81 * john >= 58)
m.addConstr(3.34 * laura + 8.31 * bill >= 16)
m.addConstr(3.34 * laura + 7.32 * mary >= 9)
m.addConstr(3.34 * laura + 5.31 * john >= 15)
m.addConstr(1.13 * paul + 7.32 * mary >= 9)
m.addConstr(7.32 * mary + 8.31 * bill + 5.31 * john >= 14)
m.addConstr(3.34 * laura + 1.13 * paul + 7.32 * mary + 8.31 * bill + 5.31 * john >= 14)
m.addConstr(10 * laura - 10 * bill >= 0)
m.addConstr(3.34 * laura + 8.31 * bill <= 87)
m.addConstr(1.13 * paul + 7.32 * mary <= 54)
m.addConstr(3.34 * laura + 1.13 * paul <= 27)
m.addConstr(8.31 * bill + 5.31 * john <= 83)
m.addConstr(3.34 * laura + 5.31 * john <= 89)
m.addConstr(1.13 * paul + 8.31 * bill <= 27)
m.addConstr(7.32 * mary + 8.31 * bill <= 33)
m.addConstr(1.13 * paul + 5.31 * john <= 28)
m.addConstr(3.34 * laura + 7.32 * mary <= 81)
m.addConstr(3.34 * laura + 8.31 * bill + 5.31 * john <= 90)
m.addConstr(1.13 * paul + 7.32 * mary + 8.31 * bill <= 75)
m.addConstr(3.34 * laura + 1.13 * paul + 7.32 * mary <= 22)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

