
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, names=["apple_pies", "apples", "kiwis", "chicken_breasts", "cherry_pies", "milkshakes"])


    # Set objective function
    obj = 9*x[0]*x[1] + 7*x[0]*x[2] + 9*x[0]*x[4] + x[0]*x[5] + 5*x[1]**2 + 2*x[1]*x[2] + x[1]*x[3] + 9*x[1]*x[4] + 7*x[2]**2 + 8*x[2]*x[3] + 6*x[2]*x[5] + 8*x[3]**2 + 7*x[3]*x[4] + 6*x[3]*x[5] + 3*x[4]**2 + 9*x[0] + 2*x[1] + 3*x[2] + x[3] + 7*x[4] + 2*x[5]
    m.setObjective(obj, gp.GRB.MAXIMIZE)

    # Add constraints
    tastiness_ratings = [25, 22, 10, 23, 13, 8]
    m.addConstr(23*x[3] + 8*x[5] >= 72)
    m.addConstr(tastiness_ratings[0]**2*x[0]**2 + tastiness_ratings[4]**2*x[4]**2 >= 66)
    m.addConstr(22*x[1] + 23*x[3] + 8*x[5] >= 109)
    m.addConstr(22*x[1] + 10*x[2] + 23*x[3] >= 109)
    m.addConstr(tastiness_ratings[0]**2*x[0]**2 + tastiness_ratings[4]**2*x[4]**2 + tastiness_ratings[5]**2*x[5]**2 >= 109)
    m.addConstr(25*x[0] + 22*x[1] + 8*x[5] >= 109)
    m.addConstr(10*x[2] + 13*x[4] + 8*x[5] >= 109)
    m.addConstr(22**2*x[1]**2 + 23**2*x[3]**2 + 8**2*x[5]**2 >= 105)
    m.addConstr(22*x[1] + 10*x[2] + 23*x[3] >= 105)
    m.addConstr(tastiness_ratings[0]**2*x[0]**2 + tastiness_ratings[4]**2*x[4]**2 + tastiness_ratings[5]**2*x[5]**2 >= 105)
    m.addConstr(tastiness_ratings[0]**2*x[0]**2 + tastiness_ratings[1]**2*x[1]**2 + tastiness_ratings[5]**2*x[5]**2 >= 105)
    m.addConstr(10*x[2] + 13*x[4] + 8*x[5] >= 105)
    # ... (rest of the constraints)

    m.addConstr(sum(tastiness_ratings[i] * x[i] for i in range(6)) <= 672)


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
