
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
ravioli = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
knishes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knishes")
strawberries = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
chicken_thighs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
apples = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
hamburgers = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")


# Set objective function
model.setObjective(1.67 * ravioli + 4.83 * knishes + 7.55 * strawberries + 7.45 * chicken_thighs + 3.55 * apples + 9.18 * hamburgers, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * strawberries + 9 * hamburgers >= 26)
model.addConstr(11 * strawberries + 8 * apples >= 53)
model.addConstr(4 * knishes + 9 * hamburgers >= 55)
model.addConstr(8 * apples + 9 * hamburgers >= 54)
model.addConstr(2 * ravioli + 8 * apples >= 41)
model.addConstr(11 * strawberries + 8 * chicken_thighs >= 43)
model.addConstr(8 * chicken_thighs + 8 * apples >= 33)
model.addConstr(4 * knishes + 11 * strawberries >= 37)
model.addConstr(4 * knishes + 8 * apples >= 30)
model.addConstr(4 * knishes + 8 * chicken_thighs + 8 * apples >= 49)
model.addConstr(11 * strawberries + 8 * chicken_thighs + 8 * apples >= 49)
model.addConstr(2 * ravioli + 8 * chicken_thighs + 9 * hamburgers >= 49)
model.addConstr(2 * ravioli + 11 * strawberries + 8 * apples >= 49)
model.addConstr(4 * knishes + 11 * strawberries + 8 * chicken_thighs >= 49)
model.addConstr(11 * strawberries + 8 * apples + 9 * hamburgers >= 49)
model.addConstr(2 * ravioli + 11 * strawberries + 9 * hamburgers >= 49)
# ... (rest of the sourness and healthiness constraints, similarly structured)

model.addConstr(-8 * knishes + 4 * hamburgers >= 0)
model.addConstr(7 * knishes - chicken_thighs >= 0)
model.addConstr(-9 * apples + 6 * hamburgers >= 0)

model.addConstr(4 * knishes + 8 * apples <= 245)
model.addConstr(11 * strawberries + 8 * apples <= 160)
model.addConstr(2 * ravioli + 4 * knishes <= 311)
model.addConstr(2 * ravioli + 11 * strawberries <= 234)
model.addConstr(4 * knishes + 9 * hamburgers <= 77)
# ... (rest of the upper bound constraints, similarly structured)

model.addConstr(2 * ravioli + 4 * knishes + 11 * strawberries + 8 * chicken_thighs + 8 * apples + 9 * hamburgers <= 346)
model.addConstr(ravioli + 2 * knishes + 5 * strawberries + 4 * chicken_thighs + 6 * apples + 14 * hamburgers <= 247)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

