
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["hamburgers", "bowls of pasta", "slices of pizza", "bowls of instant ramen", "granola bars"])


# Set objective function
m.setObjective(1*x[0] + 1*x[1] + 3*x[2] + 6*x[3] + 4*x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x[1] + 5*x[2] >= 13)
m.addConstr(4*x[0] + 2*x[1] + 5*x[2] + 5*x[3] + 7*x[4] >= 13)
m.addConstr(1*x[0] + 3*x[3] >= 13)
m.addConstr(1*x[0] + 1*x[4] >= 8)
m.addConstr(3*x[3] + 1*x[4] >= 13)
m.addConstr(1*x[0] + 8*x[2] + 1*x[4] >= 13)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] >= 13)
m.addConstr(1*x[0] + 4*x[1] + 3*x[3] >= 13)
m.addConstr(4*x[1] + 3*x[3] + 1*x[4] >= 13)
m.addConstr(4*x[1] + 8*x[2] + 3*x[3] >= 13)
m.addConstr(1*x[0] + 8*x[2] + 1*x[4] >= 12)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] >= 12)
m.addConstr(1*x[0] + 4*x[1] + 3*x[3] >= 12)
m.addConstr(4*x[1] + 3*x[3] + 1*x[4] >= 12)
m.addConstr(4*x[1] + 8*x[2] + 3*x[3] >= 12)
m.addConstr(1*x[0] + 8*x[2] + 1*x[4] >= 14)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] >= 14)
m.addConstr(1*x[0] + 4*x[1] + 3*x[3] >= 14)
m.addConstr(4*x[1] + 3*x[3] + 1*x[4] >= 14)
m.addConstr(4*x[1] + 8*x[2] + 3*x[3] >= 14)
m.addConstr(1*x[0] + 8*x[2] + 1*x[4] >= 18)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] >= 18)
m.addConstr(1*x[0] + 4*x[1] + 3*x[3] >= 18)
m.addConstr(4*x[1] + 3*x[3] + 1*x[4] >= 18)
m.addConstr(4*x[1] + 8*x[2] + 3*x[3] >= 18)
m.addConstr(1*x[0] + 8*x[2] + 1*x[4] >= 19)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] >= 19)
m.addConstr(1*x[0] + 4*x[1] + 3*x[3] >= 19)
m.addConstr(4*x[1] + 3*x[3] + 1*x[4] >= 19)
m.addConstr(4*x[1] + 8*x[2] + 3*x[3] >= 19)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] + 3*x[3] + 1*x[4] >= 19)
m.addConstr(-6*x[1] + 8*x[4] >= 0)
m.addConstr(3*x[0] - 6*x[1] >= 0)
m.addConstr(4*x[0] + 5*x[3] <= 91)
m.addConstr(5*x[2] + 7*x[4] <= 74)
m.addConstr(4*x[0] + 7*x[4] <= 102)
m.addConstr(4*x[0] + 2*x[1] <= 91)
m.addConstr(2*x[1] + 7*x[4] <= 58)
m.addConstr(4*x[0] + 2*x[1] + 5*x[2] <= 56)
m.addConstr(4*x[1] + 8*x[2] <= 61)
m.addConstr(1*x[0] + 3*x[3] <= 88)
m.addConstr(4*x[1] + 3*x[3] <= 94)
m.addConstr(1*x[0] + 3*x[3] + 1*x[4] <= 79)
m.addConstr(4*x[1] + 8*x[2] + 1*x[4] <= 45)
m.addConstr(4*x[1] + 3*x[3] + 1*x[4] <= 102)
m.addConstr(4*x[0] <= 103)
m.addConstr(1*x[0] + 4*x[1] + 8*x[2] + 3*x[3] + 1*x[4] <= 105)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

