
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="lemons")


    # Set objective function
    m.setObjective(9*x0 + 6*x1 + 8*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 6*x1 >= 37, "c1")
    m.addConstr(6*x1 + 11*x2 >= 51, "c2")
    m.addConstr(7*x0 + 6*x1 + 11*x2 >= 52, "c3")
    m.addConstr(14*x1 + 12*x2 >= 37, "c4")
    m.addConstr(4*x0 + 14*x1 >= 30, "c5")
    m.addConstr(4*x0 + 14*x1 + 12*x2 >= 30, "c6")
    m.addConstr(-8*x1 + 2*x2 >= 0, "c7")
    m.addConstr(6*x1 + 11*x2 <= 163, "c8")
    m.addConstr(7*x0 + 6*x1 + 11*x2 <= 98, "c9")
    m.addConstr(4*x0 + 14*x1 <= 107, "c10")
    m.addConstr(14*x1 + 12*x2 <= 64, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
