
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="protein_bars", lb=0)
x1 = m.addVar(name="cherry_pies", lb=0)
x2 = m.addVar(name="lemons", lb=0)

# Set the objective function
m.setObjective(9 * x0 + 6 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * x0 + 6 * x1 >= 37)
m.addConstr(6 * x1 + 11 * x2 >= 51)
m.addConstr(7 * x0 + 6 * x1 + 11 * x2 >= 52)
m.addConstr(14 * x1 + 12 * x2 >= 37)
m.addConstr(4 * x0 + 14 * x1 >= 30)
m.addConstr(4 * x0 + 14 * x1 + 12 * x2 >= 30)
m.addConstr(-8 * x1 + 2 * x2 >= 0)
m.addConstr(6 * x1 + 11 * x2 <= 163)
m.addConstr(7 * x0 + 6 * x1 + 11 * x2 <= 98)
m.addConstr(4 * x0 + 14 * x1 <= 107)
m.addConstr(14 * x1 + 12 * x2 <= 64)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein bars: {x0.varValue}")
    print(f"Cherry pies: {x1.varValue}")
    print(f"Lemons: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
