
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    sashimi = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sashimi")
    hamburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")


    # Set objective function
    m.setObjective(6.76*sashimi**2 + 4.69*sashimi*hamburgers + 2.99*hamburgers, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*sashimi + 12*hamburgers >= 41, "sourness_lower_bound")
    m.addConstr(6*sashimi + 9*hamburgers >= 17, "fiber_lower_bound")
    m.addConstr(-5*sashimi + 4*hamburgers >= 0, "linear_constraint")
    m.addConstr(8*sashimi**2 + 12*hamburgers**2 <= 80, "sourness_squared_upper_bound")
    m.addConstr(6*sashimi + 9*hamburgers <= 61, "fiber_upper_bound")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('sashimi:', sashimi.x)
        print('hamburgers:', hamburgers.x)
    elif m.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
