
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="sashimi", lb=0)  # Assuming non-negativity
    x2 = model.addVar(name="hamburgers", lb=0)  # Assuming non-negativity

    # Objective function
    model.setObjective(6.76 * x1**2 + 4.69 * x1 * x2 + 2.99 * x2**2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x1 + 12 * x2 >= 41, name="sourness_index")
    model.addConstr(6 * x1 + 9 * x2 >= 17, name="fiber_content")
    model.addConstr(-5 * x1 + 4 * x2 >= 0, name="linear_combination")
    model.addConstr(64 * x1**2 + 144 * x2**2 <= 80, name="squared_sourness_index")
    model.addConstr(6 * x1 + 9 * x2 <= 61, name="fiber_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Sashimi: {x1.varValue}")
        print(f"Hamburgers: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
