
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
cbrn_platoons = m.addVar(vtype=gp.GRB.INTEGER, name="cbrn_platoons")
light_infantry = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry")
artillery = m.addVar(vtype=gp.GRB.INTEGER, name="artillery")
engineer = m.addVar(vtype=gp.GRB.INTEGER, name="engineer")


# Set objective function
m.setObjective(6.42 * cbrn_platoons + 2.54 * light_infantry + 1.76 * artillery + 4.16 * engineer, gp.GRB.MINIMIZE)

# Add constraints

m.addConstr(4 * cbrn_platoons + 13 * engineer >= 21)
m.addConstr(4 * cbrn_platoons + 6 * artillery >= 30)
m.addConstr(14 * light_infantry + 6 * artillery >= 23)
m.addConstr(6 * artillery + 13 * engineer >= 27)
m.addConstr(4 * cbrn_platoons + 6 * artillery + 13 * engineer >= 29)
m.addConstr(4 * cbrn_platoons + 14 * light_infantry + 13 * engineer >= 29)
m.addConstr(4 * cbrn_platoons + 6 * artillery + 13 * engineer >= 30)
m.addConstr(4 * cbrn_platoons + 14 * light_infantry + 13 * engineer >= 30)
m.addConstr(4 * cbrn_platoons + 14 * light_infantry + 6 * artillery + 13 * engineer >= 30)

m.addConstr(7 * light_infantry + 14 * engineer >= 53)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry >= 28)
m.addConstr(2 * cbrn_platoons + 14 * engineer >= 49)
m.addConstr(2 * cbrn_platoons + 8 * artillery >= 21)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 14 * engineer >= 29)
m.addConstr(7 * light_infantry + 8 * artillery + 14 * engineer >= 29)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 8 * artillery >= 29)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 14 * engineer >= 38)
m.addConstr(7 * light_infantry + 8 * artillery + 14 * engineer >= 38)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 8 * artillery >= 38)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 14 * engineer >= 31)
m.addConstr(7 * light_infantry + 8 * artillery + 14 * engineer >= 31)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 8 * artillery >= 31)
m.addConstr(2 * cbrn_platoons + 7 * light_infantry + 8 * artillery + 14 * engineer >= 31)


m.addConstr(10 * cbrn_platoons + 9 * artillery >= 23)
m.addConstr(10 * cbrn_platoons + 3 * engineer >= 39)
m.addConstr(13 * light_infantry + 9 * artillery >= 19)
m.addConstr(13 * light_infantry + 3 * engineer >= 29)
# Removed duplicate constraints
m.addConstr(10 * cbrn_platoons + 13 * light_infantry + 9 * artillery + 3 * engineer >= 38)

m.addConstr(14 * cbrn_platoons + 13 * artillery >= 27)
m.addConstr(13 * artillery + 7 * engineer >= 30)
# Removed duplicate constraints
m.addConstr(14 * cbrn_platoons + 13 * light_infantry + 13 * artillery + 7 * engineer >= 27)

m.addConstr(artillery - engineer >= 0)
m.addConstr(-5 * cbrn_platoons + 9 * engineer >= 0)

m.addConstr(4 * cbrn_platoons + 6 * artillery + 13 * engineer <= 49)
m.addConstr(14 * light_infantry + 6 * artillery + 13 * engineer <= 69)
m.addConstr(4 * cbrn_platoons + 14 * light_infantry + 6 * artillery <= 103)

m.addConstr(7 * light_infantry + 8 * artillery <= 210)
m.addConstr(13 * light_infantry + 3 * engineer <= 135)
m.addConstr(10 * cbrn_platoons + 9 * artillery <= 101)
m.addConstr(10 * cbrn_platoons + 9 * artillery + 3 * engineer <= 163)
m.addConstr(14 * cbrn_platoons + 13 * light_infantry <= 119)
m.addConstr(13 * light_infantry + 13 * artillery + 7 * engineer <= 66)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    print('CBRN Platoons:', cbrn_platoons.x)
    print('Light Infantry Companies:', light_infantry.x)
    print('Artillery Batteries:', artillery.x)
    print('Engineer Platoons:', engineer.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

